<?php
declare(strict_types=1);
/**
 * FRESIL C.A. — API /api/categorias/index.php
 * GET  → árbol o plana (?plana=1)
 * POST → crear (admin)
 * PUT?id=N → actualizar (admin)
 */
require_once dirname(__DIR__,2).'/config/config.php';
require_once CLASSES_PATH.'/Database.php';
require_once CLASSES_PATH.'/JWT.php';
require_once CLASSES_PATH.'/Categoria.php';
require_once ROOT_PATH.'/middleware/AuthMiddleware.php';

header('Content-Type: application/json; charset=utf-8');
if ($_SERVER['REQUEST_METHOD']==='OPTIONS'){http_response_code(204);exit;}

$method = $_SERVER['REQUEST_METHOD'];
$id     = isset($_GET['id']) ? (int)$_GET['id'] : null;

try {
    $user   = AuthMiddleware::requireAuth();
    $modelo = new Categoria();

    switch ($method) {
        case 'GET':
            if ($id) {
                AuthMiddleware::respond($modelo->obtener($id));
            } elseif (isset($_GET['plana'])) {
                AuthMiddleware::respond($modelo->listarPlana());
            } else {
                AuthMiddleware::respond($modelo->arbol());
            }
            break;
        case 'POST':
            AuthMiddleware::requireRole('admin');
            $body = json_decode(file_get_contents('php://input'),true,512,JSON_THROW_ON_ERROR);
            AuthMiddleware::respond($modelo->crear($body,(int)$user['id']),201);
            break;
        case 'PUT':
            if (!$id) { AuthMiddleware::abort(400,'ID requerido.'); }
            AuthMiddleware::requireRole('admin');
            $body = json_decode(file_get_contents('php://input'),true,512,JSON_THROW_ON_ERROR);
            AuthMiddleware::respond($modelo->actualizar($id,$body,(int)$user['id']));
            break;
        default: AuthMiddleware::abort(405,'Método no permitido.');
    }
} catch (RuntimeException $e) {
    AuthMiddleware::abort($e->getCode()?:500,$e->getMessage());
} catch(\Throwable $e) {
    AuthMiddleware::abort(500, APP_ENV==='development'?$e->getMessage():'Error interno.');
}
