<?php
declare(strict_types=1);
/**
 * POST /api/auth/refresh.php  — Renovar access token
 */
require_once dirname(__DIR__, 2) . '/config/config.php';
require_once CLASSES_PATH . '/Database.php';
require_once CLASSES_PATH . '/JWT.php';
require_once CLASSES_PATH . '/Auth.php';
require_once ROOT_PATH . '/middleware/AuthMiddleware.php';

header('Content-Type: application/json; charset=utf-8');
if ($_SERVER['REQUEST_METHOD'] !== 'POST') { AuthMiddleware::abort(405, 'Método no permitido.'); }

try {
    $body = json_decode(file_get_contents('php://input'), true, flags: JSON_THROW_ON_ERROR);
    $refreshToken = trim((string)($body['refresh_token'] ?? ''));
    if (empty($refreshToken)) { AuthMiddleware::abort(400, 'refresh_token requerido.'); }
    $auth = new Auth();
    AuthMiddleware::respond($auth->refresh($refreshToken, AuthMiddleware::getClientIp()));
} catch (RuntimeException $e) {
    AuthMiddleware::abort($e->getCode() ?: 401, $e->getMessage());
} catch (\Throwable $e) {
    AuthMiddleware::abort(500, 'Error interno.');
}
