<?php
declare(strict_types=1);

/**
 * ============================================================
 * FRESIL C.A. — API: POST /api/auth/logout.php
 * ============================================================
 */

require_once dirname(__DIR__, 2) . '/config/config.php';
require_once CLASSES_PATH . '/Database.php';
require_once CLASSES_PATH . '/JWT.php';
require_once CLASSES_PATH . '/Auth.php';
require_once ROOT_PATH . '/middleware/AuthMiddleware.php';

header('Content-Type: application/json; charset=utf-8');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    AuthMiddleware::abort(405, 'Método no permitido.');
}

try {
    $usuario = AuthMiddleware::requireAuth();

    $body  = json_decode(file_get_contents('php://input'), true, flags: JSON_THROW_ON_ERROR);
    $refreshToken = (string)($body['refresh_token'] ?? '');

    $auth = new Auth();
    $ip   = AuthMiddleware::getClientIp();
    $auth->logout($refreshToken, (int)$usuario['id'], $ip);

    AuthMiddleware::respond(['mensaje' => 'Sesión cerrada correctamente.']);

} catch (RuntimeException $e) {
    AuthMiddleware::abort($e->getCode() ?: 401, $e->getMessage());
} catch (\Throwable $e) {
    AuthMiddleware::abort(500, 'Error interno del servidor.');
}
